// doublyLinked.java
// demonstruje dziaanie listy dwukierunkowej
// uruchomienie programu: C>java DoublyLinkedApp
////////////////////////////////////////////////////////////////
class Link
   {
   public long dData;                 // dane
   public Link next;                  // nastpny element
   public Link previous;              // poprzedni element
// -------------------------------------------------------------
   public Link(long d)                // konstruktor
      { dData = d; }
// -------------------------------------------------------------
   public void displayLink()          // wypisuje dane
      { System.out.print(dData + " "); }
// -------------------------------------------------------------
   }  // koniec klasy Link
////////////////////////////////////////////////////////////////
class DoublyLinkedList
   {
   private Link first;               // referencja do pierwszego elementu
   private Link last;                // referencja do ostatniego elementu
// -------------------------------------------------------------
   public DoublyLinkedList()         // konstruktor
      {
      first = null;                  // na razie brak elementw
      last = null;
      }
// -------------------------------------------------------------
   public boolean isEmpty()          // zwraca true, jeeli lista jest pusta
      { return first==null; }
// -------------------------------------------------------------
   public void insertFirst(long dd)  // wstawienie na pocztek listy
      {
      Link newLink = new Link(dd);   // tworzymy nowy element

      if( isEmpty() )                 // jeeli lista jest pusta...
         last = newLink;              // ...last --> newLink
      else
         first.previous = newLink;    // newLink <-- dotychczas pierwszy
      newLink.next = first;           // newLink --> dotychczas pierwszy
      first = newLink;                // first --> newLink
      }
// -------------------------------------------------------------
   public void insertLast(long dd)   // wstawienie na koniec listy
      {
      Link newLink = new Link(dd);   // tworzymy nowy element
      if( isEmpty() )                // jeeli lista jest pusta...
         first = newLink;            // ...first --> newLink
      else
         {
         last.next = newLink;        // poprzednio ostatni --> newLink
         newLink.previous = last;    // poprzednio ostatni <-- newLink
         }
      last = newLink;                // last --> newLink
      }
// -------------------------------------------------------------
   public Link deleteFirst()         // usunicie pierwszego elementu
      {                              // (zakadamy, e lista nie jest pusta)
      Link temp = first;
      if(first.next == null)         // jeeli tylko jeden element...
         last = null;                // ...last --> null
      else
         first.next.previous = null; // null <-- poprzednio drugi
      first = first.next;            // first --> poprzednio drugi
      return temp;
      }
// -------------------------------------------------------------
   public Link deleteLast()          // usunicie ostatniego elementu
      {                              // (zakadamy, e lista nie jest pusta)
      Link temp = last;
      if(first.next == null)         // jeeli tylko jeden element...
         first = null;               // ...first --> null
      else
         last.previous.next = null;  // poprzednio przedostatni --> null
      last = last.previous;          // last --> poprzednio przedostatni
      return temp;
      }
// -------------------------------------------------------------
                                     // wstawienie elementu dd po elemencie key
   public boolean insertAfter(long key, long dd)
      {                              // (zakadamy, e lista nie jest pusta)
      Link current = first;          // zaczynamy od pocztku
      while(current.dData != key)    // dopki nie znalelimy elementu...
         {
         current = current.next;     // przechodzimy do nastpnego
         if(current == null)
            return false;            // nie znalelimy elementu
         }
      Link newLink = new Link(dd);   // tworzymy nowy element

      if(current==last)              // jeeli wstawiamy na kocu...
         {
         newLink.next = null;        // newLink --> null
         last = newLink;             // newLink <-- last
         }
      else                           // jeeli nie na kocu...
         {
         newLink.next = current.next; // newLink --> poprzednio nastpny
                                      // newLink <-- poprzednio nastpny
         current.next.previous = newLink;
         }
      newLink.previous = current;    // aktualny element <-- newLink
      current.next = newLink;        // aktualny element --> newLink
      return true;                   // wstawiono element, wic zwracamy true
      }
// -------------------------------------------------------------
   public Link deleteKey(long key)   // usunicie elementu o okrelonym kluczu
      {                              // (zakadamy, e lista nie jest pusta)
      Link current = first;          // zaczynamy od pocztku
      while(current.dData != key)    // dopki nie znalelimy elementu...
         {
         current = current.next;     // przechodzimy do nastpnego
         if(current == null)
            return null;             // nie znalelimy elementu
         }
      if(current==first)             // jeeli znaleziony to pierwszy element...
         first = current.next;       // ...first --> poprzednio drugi
      else                           // jeeli nie jest pierwszy..
                                     // poprzednik aktualnego --> nastpnik aktualnego
         current.previous.next = current.next;

      if(current==last)              // jeeli znaleziony to ostatni element...
         last = current.previous;    // ...last --> przedostatni
      else                           // jeeli nie jest ostatni...
                                     // poprzednik aktualnego <-- nastpnik aktualnego
         current.next.previous = current.previous;
      return current;                // zwracamy usunity element
      }
// -------------------------------------------------------------
   public void displayForward()
      {
      System.out.print("Lista (pocztek-->koniec): ");
      Link current = first;          // zaczynamy od pocztku
      while(current != null)         // dopki nie koniec listy...
         {
         current.displayLink();      // ...wypisujemy zawarto...
         current = current.next;     // ...i przechodzimy do nastpnego
         }
      System.out.println("");
      }
// -------------------------------------------------------------
   public void displayBackward()
      {
      System.out.print("Lista (koniec-->pocztek): ");
      Link current = last;           // zaczynamy od koca
      while(current != null)         // dopkie nie jestemy na pocztku listy...
         {
         current.displayLink();      // ...wypisujemy zawarto...
         current = current.previous; // ...i przechodzimy do poprzedniego
         }
      System.out.println("");
      }
// -------------------------------------------------------------
   }  // koniec klasy DoublyLinkedList
////////////////////////////////////////////////////////////////
class DoublyLinkedApp
   {
   public static void main(String[] args)
      {                             // tworzymy list
      DoublyLinkedList theList = new DoublyLinkedList();

      theList.insertFirst(22);      // wstawiamy na pocztek
      theList.insertFirst(44);
      theList.insertFirst(66);

      theList.insertLast(11);       // wstawiamy na koniec
      theList.insertLast(33);
      theList.insertLast(55);

      theList.displayForward();     // wypisujemy list normalnie
      theList.displayBackward();    // wypisujemy list odwrotnie

      theList.deleteFirst();        // usuwamy pierwszy element
      theList.deleteLast();         // usuwamy ostatni element
      theList.deleteKey(11);        // usuwamy element o kluczu 11

      theList.displayForward();     // wypisujemy list normalnie

      theList.insertAfter(22, 77);  // wstawiamy 77 po 22
      theList.insertAfter(33, 88);  // wstawiamy 88 po 33

      theList.displayForward();     // wypisujemy list normalnie
      }  // koniec main()
   }  // koniec klasy DoublyLinkedApp
////////////////////////////////////////////////////////////////
